#include "GameMap.h"

//COLOR MAP FOR TILES
	//Black - Floor Block
	//White - Destructable Block
	//Yellow - Question Block with Stored Coin
	//Red - Question Block with Stored Power Up
	//Blue - End Flag
	//0, 255, 200 - Invisible Block with One Up
	//0, 85, 0 - Small Pipe
	//0, 170, 0 - Medium Pipe
	//0, 255, 0 - Big Pipe
	//118, 118, 118 - Stair Block
	//160, 100, 0 - Goomba
	//0, 255, 170 - Koopa
	//85, 85, 85 - Small Cloud
	//85, 170, 85 - Medium Cloud
	//85, 255, 85 - Big Cloud
	//85, 85, 170 - Small Bush
	//170, 85, 170 - Medium Bush
	//255, 85, 170 - Big Bush
	//85, 85, 255 - Small Hill
	//255, 85, 255 - Big Hill

GameMap::GameMap()
{

}

GameMap::~GameMap()
{

}

bool GameMap::load(std::string filepath, sf::RenderWindow* window, ItemManager* itemManager, EnemyManager* enemyManager)
{
	int currentXPixel = 0, currentYPixel = 0;	//Set our current pixels in the tile map image initially to 0
	
	sf::Image tileMapImage;	//Create an image object for our tilemap.png

	if (!tileMapImage.loadFromFile(filepath))	//If we fail to load the file
	{
		std::cout << "Error loading map file! The map will not load in correctly and gameplay will fail! Please check the " + filepath + " file exists." << std::endl;	//Display an error to the user
		return false;
	}

	else
	{
		for (currentYPixel; currentYPixel <= tileMapImage.getSize().y - 1; currentYPixel++)	//For every y pixel
		{
			for (currentXPixel; currentXPixel <= tileMapImage.getSize().x - 1; currentXPixel = currentXPixel++)	//For every x pixel
			{
				sf::Color currentPixelColour = tileMapImage.getPixel(currentXPixel, currentYPixel);	//Get the colour of the current pixel
				if (currentPixelColour != sf::Color::Transparent)
				{
					if (currentPixelColour == sf::Color::Black)
					{
						itemManager->createItem(new Block(), GameItems::BlockType::Floor, GameItems::StoredItems::StoredNothing, sf::Vector2f(currentXPixel, currentYPixel));	//Spawn a floor block here
						currentXPixel += 54;	//We move on 54 pixels (as a block is 55 wide, we know we can't have anything else yet)
					}

					else if (currentPixelColour == sf::Color::White)
					{
						itemManager->createItem(new Block(), GameItems::BlockType::Destructable, GameItems::StoredItems::StoredNothing, sf::Vector2f(currentXPixel, currentYPixel));	//Spawn a destructable block here
						currentXPixel += 54;	//We move on 54 pixels (as a block is 55 wide, we know we can't have anything else yet)
					}

					else if (currentPixelColour == sf::Color::Yellow)
					{
						itemManager->createItem(new Block(), GameItems::BlockType::Question, GameItems::StoredItems::StoredCoin, sf::Vector2f(currentXPixel, currentYPixel));	//Spawn a question block here with a coin inside
						currentXPixel += 54;	//We move on 54 pixels (as a block is 55 wide, we know we can't have anything else yet)
					}

					else if (currentPixelColour == sf::Color::Red)
					{
						itemManager->createItem(new Block(), GameItems::BlockType::Question, GameItems::StoredItems::StoredPowerUp, sf::Vector2f(currentXPixel, currentYPixel));	//Spawn a question block with a power up inside
						currentXPixel += 54;	//We move on 54 pixels (as a block is 55 wide, we know we can't have anything else yet)
					}

					else if (currentPixelColour.r == 0 && currentPixelColour.g == 255 && currentPixelColour.b == 200)
					{
						itemManager->createItem(new Block(), GameItems::BlockType::Invisible, GameItems::StoredItems::StoredOneUp, sf::Vector2f(currentXPixel, currentYPixel));	//Spawn an invisible block with a one up inside
						currentXPixel += 54;	//We move on 54 pixels (as a block is 55 wide, we know we can't have anything else yet)
					}

					else if (currentPixelColour.r == 0 && currentPixelColour.g == 85 && currentPixelColour.b == 0)
					{
						itemManager->createItem(new Pipe(), GameItems::SpriteSize::Small, sf::Vector2f(currentXPixel, currentYPixel));	//Create a small pipe here
						currentXPixel += 109;	//We move on 109 pixels (as a pipe is 110 wide, we know we can't have anything else yet)
					}

					else if (currentPixelColour.r == 0 && currentPixelColour.g == 170 && currentPixelColour.b == 0)
					{
						itemManager->createItem(new Pipe(), GameItems::SpriteSize::Medium, sf::Vector2f(currentXPixel, currentYPixel));	//Create a medium pipe here
						currentXPixel += 109;	//We move on 109 pixels (as a pipe is 110 wide, we know we can't have anything else yet)
					}

					else if (currentPixelColour.r == 0 && currentPixelColour.g == 255 && currentPixelColour.b == 0)
					{
						itemManager->createItem(new Pipe(), GameItems::SpriteSize::Big, sf::Vector2f(currentXPixel, currentYPixel));	//Create a big pipe here
						currentXPixel += 109;	//We move on 109 pixels (as a pipe is 110 wide, we know we can't have anything else yet)
					}

					else if (currentPixelColour.r == 118 && currentPixelColour.g == 118 && currentPixelColour.b == 118)
					{
						itemManager->createItem(new Block(), GameItems::BlockType::Stair, GameItems::StoredItems::StoredNothing, sf::Vector2f(currentXPixel, currentYPixel));	//Create a stair block here
						currentXPixel += 54;	//We move on 54 pixels (as a block is 55 wide, we know we can't have anything else yet)
					}

					else if (currentPixelColour == sf::Color::Blue)
					{
						itemManager->createItem(new Pole(), sf::Vector2f(currentXPixel, currentYPixel));	//Create a pole here
						itemManager->createItem(new Flag(), sf::Vector2f(currentXPixel - 41, currentYPixel + 31));	//Create the flag offset 41 pixels from the pole
						itemManager->createItem(new Castle(), GameItems::SpriteSize::Small, sf::Vector2f(currentXPixel + 206, currentYPixel + 301));	//Create a small castle 206 and 301 pixels offset from the pole
					}

					else if (currentPixelColour.r == 160 && currentPixelColour.g == 100 && currentPixelColour.b == 0)
					{
						enemyManager->create(MySprite::SpriteType::GoombaSprite, sf::Vector2f(currentXPixel, currentYPixel));	//Spawn a Goomba here
					}

					else if (currentPixelColour.r == 0 && currentPixelColour.g == 255 && currentPixelColour.b == 170)
					{
						enemyManager->create(MySprite::SpriteType::KoopaSprite, sf::Vector2f(currentXPixel, currentYPixel));	//Spawn a Koopa here
					}

					else if (currentPixelColour.r == 85 && currentPixelColour.g == 85 && currentPixelColour.b == 85)
					{
						itemManager->createItem(new Cloud(), GameItems::SpriteSize::Small, sf::Vector2f(currentXPixel, currentYPixel));	//Create a small cloud here
					}

					else if (currentPixelColour.r == 85 && currentPixelColour.g == 170 && currentPixelColour.b == 85)
					{
						itemManager->createItem(new Cloud(), GameItems::SpriteSize::Medium, sf::Vector2f(currentXPixel, currentYPixel));	//Create a medium cloud here
					}

					else if (currentPixelColour.r == 85 && currentPixelColour.g == 255 && currentPixelColour.b == 85)
					{
						itemManager->createItem(new Cloud(), GameItems::SpriteSize::Big, sf::Vector2f(currentXPixel, currentYPixel));	//Create a big cloud here
					}

					else if (currentPixelColour.r == 85 && currentPixelColour.g == 85 && currentPixelColour.b == 170)
					{
						itemManager->createItem(new Bush(), GameItems::SpriteSize::Small, sf::Vector2f(currentXPixel, currentYPixel));	//Create a small bush here
					}

					else if (currentPixelColour.r == 170 && currentPixelColour.g == 85 && currentPixelColour.b == 170)
					{
						itemManager->createItem(new Bush(), GameItems::SpriteSize::Medium, sf::Vector2f(currentXPixel, currentYPixel));	//Create a medium bush here
					}

					else if (currentPixelColour.r == 255 && currentPixelColour.g == 85 && currentPixelColour.b == 170)
					{
						itemManager->createItem(new Bush(), GameItems::SpriteSize::Big, sf::Vector2f(currentXPixel, currentYPixel));	//Create a big bush here
					}

					else if (currentPixelColour.r == 85 && currentPixelColour.g == 85 && currentPixelColour.b == 255)
					{
						itemManager->createItem(new Hill(), GameItems::SpriteSize::Small, sf::Vector2f(currentXPixel, currentYPixel));	//Create a small hill here
					}

					else if (currentPixelColour.r == 255 && currentPixelColour.g == 85 && currentPixelColour.b == 255)
					{
						itemManager->createItem(new Hill(), GameItems::SpriteSize::Big, sf::Vector2f(currentXPixel, currentYPixel));	//Create a big hill here
					}
				}
			}

			currentXPixel = 0;	//We're moving down to the next y row, go back to the far left of the image
		}

		return true;
	}
}
